<?php
 
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
 
require_once 'vendor/autoload.php';
require_once 'conn.php';

$today = date("Y-m-d");

$Cargonya=0;
$stmt = $pdo->prepare("select distinct periode_bulan from dcamelsy_piutang");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    $bulanDB = $row['periode_bulan'];
}

$bulanDB="April";


$query = "select * from dcamelsy_piutang";
$stmt = $pdo->prepare($query);
$stmt->execute();
$data_laporan = $stmt->fetchAll(PDO::FETCH_ASSOC);
$totalRow = count($data_laporan);

if(empty($data_laporan)){
  make_empty_spreadsheet("There is nothing to report today", $today);
  send_daily_report($today);
}else {
  make_spreadsheet("Laporan Piutang", $data_laporan, $today, $totalRow, $Cargonya, $xnominal_hotel, $xnominal_activity, $HotelAc, $TotalBoat, $TotalExtra, $bulanDB);
  send_daily_report($today);
}

// Create new Spreadsheet object

function make_spreadsheet($headerText, $data, $date, $totalRow, $xCargo, $xHotel, $xActivity, $xHC, $TotalBoat, $TotalExtra, $bulanAktif){
  $TotalPenumpangLembongan=0;
  $TotalPenumpangSanur=0;
  
  $TL_WNA_ADULT = 0;
  $TL_WNA_CHILD = 0;
  $TL_WNI_ADULT = 0;
  $TL_WNI_CHILD = 0;
  $TL_FOC = 0;
  $TL_GUIDE = 0;
  $TL_INFANT = 0;
  
  $TS_WNA_ADULT = 0;
  $TS_WNA_CHILD = 0;
  $TS_WNI_ADULT = 0;
  $TS_WNI_CHILD = 0;
  $TS_FOC = 0;
  $TS_GUIDE = 0;
  $TS_INFANT = 0;
  
    $host="139.162.57.73";
	$user_name="dcamelsy_user";
	$password="Kita@2019";
	$database_name="dcamelsy_database";

	$konek = mysqli_connect($host, $user_name, $password, $database_name);
	
	
    $TotalBCALalu = 0;
    $TotalBRILalu = 0;
    $TotalCashLalu = 0;
    
    $TotalBCAKemarin = 0;
    $TotalBRKemarin = 0;
    $TotalCashKemarin = 0;
    
    $TotalBCASekarang = 0;
    $TotalBRISekarang = 0;
    $TotalCashSekarang = 0;
    
    $PiutangBulanLalu = 0;
    $PiutangBulanSebelum = 0;
    $PiutangBulanBerjalan = 0;
    
    
    $FeeBulanLalu = 0;
    $FeeBulanSebelum = 0;
    $FeeBulanBerjalan = 0;
    
    
    $bulanDB = $bulanAktif;
    //Setup Variable Bulan
    $bulanLalu ='';
    $bulanSebelumnya = '';
    $bulanBerjalan = '';
    if ($bulanDB=='Januari')
    {
        $bulanLalu ='Nopember';
        $bulanSebelumnya = 'Desember';
        $bulanBerjalan = 'Januari';
    }
    else if ($bulanDB=='Pebruari')
    {
        $bulanLalu ='Desember';
        $bulanSebelumnya = 'Januari';
        $bulanBerjalan = 'Pebruari';
    }
    else if ($bulanDB=='Maret')
    {
        $bulanLalu ='Januari';
        $bulanSebelumnya = 'Pebruari';
        $bulanBerjalan = 'Maret';
    }
    else if ($bulanDB=='April')
    {
        $bulanLalu ='Pebruari';
        $bulanSebelumnya = 'Maret';
        $bulanBerjalan = 'April';
    }
    else if ($bulanDB=='Mei')
    {
        $bulanLalu ='Maret';
        $bulanSebelumnya = 'April';
        $bulanBerjalan = 'Mei';
    }
    else if ($bulanDB=='Juni')
    {
        $bulanLalu ='April';
        $bulanSebelumnya = 'Mei';
        $bulanBerjalan = 'Juni';
    }
    else if ($bulanDB=='Juli')
    {
        $bulanLalu ='Mei';
        $bulanSebelumnya = 'Juni';
        $bulanBerjalan = 'Juli';
    }
    else if ($bulanDB=='Agustus')
    {
        $bulanLalu ='Juni';
        $bulanSebelumnya = 'Juli';
        $bulanBerjalan = 'Agustus';
    }
    else if ($bulanDB=='September')
    {
        $bulanLalu ='Juli';
        $bulanSebelumnya = 'Agustus';
        $bulanBerjalan = 'September';
    }
    else if ($bulanDB=='Oktober')
    {
        $bulanLalu ='Agustus';
        $bulanSebelumnya = 'September';
        $bulanBerjalan = 'Oktober';
    }
    else if ($bulanDB=='Nopember')
    {
        $bulanLalu ='September';
        $bulanSebelumnya = 'Oktober';
        $bulanBerjalan = 'Nopember';
    }
    else if ($bulanDB=='Desember')
    {
        $bulanLalu ='Oktober';
        $bulanSebelumnya = 'Nopember';
        $bulanBerjalan = 'Desember';
    }

  $spreadsheet = new Spreadsheet();
  $activeSheet = $spreadsheet->getActiveSheet();
  $activeSheet->setTitle('Laporan Piutang');
  $activeSheet->getParent()->getDefaultStyle()->getFont()->setName('Noto Sans');
  $activeSheet->getDefaultRowDimension()->setRowHeight(35);
  $lastRow = $totalRow+4;

  
  $boldFont = array(
      'font' => [
        'bold' => true,
      ],

      'alignment' => [
          'horizontal' => Alignment::HORIZONTAL_CENTER,
          'vertical' => Alignment::VERTICAL_CENTER
      ],

      'borders' => [
        'vertical' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
        ],
        'top' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
        ]
      ]
  );

  $defCellStyle = array(
    'alignment' => [
      'horizontal' => Alignment::HORIZONTAL_CENTER,
      'vertical' => Alignment::VERTICAL_TOP
    ],

    'borders' => [
      'vertical' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
      ],
    ]
  );


  $newRowStyleLembongan = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => '89c765'
        ]
    ]
);

$newRowStyleSanur = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => 'fc3865'
        ]
    ]
);
    

$newRowStyleKuning = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => 'fcba03'
        ]
    ]
);

$newRowStyleHijau = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => '00c907'
        ]
    ]
);

$newRowStyleBiru = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => '02e9ed'
        ]
    ]
);

$newRowStyleOrangeTua = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => 'd49606'
        ]
    ]
);

$newRowStylePink = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => 'ff80ec'
        ]
    ]
);

$newRowStyleHijau = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => '89c765'
        ]
    ]
);


  $activeSheet->setCellValue('A1', $headerText);
  $activeSheet->getStyle("A1")->getFont()->setSize(16);

  // Auto Width Default
  foreach (range('A','Z') as $cell) {
    $activeSheet->getColumnDimension($cell)->setAutoSize(true);
  }

  foreach (range('A','P') as $cell) {
    $activeSheet->getColumnDimension('A'.$cell)->setAutoSize(true);
  }
  

  
  //custom last header style (border workaround)
  $activeSheet->getStyle('AP4')
  ->getBorders()->getRight()
  ->setBorderStyle(Border::BORDER_THIN);
  $activeSheet->getStyle('AP4')
  ->getBorders()->getRight()
  ->setBorderStyle(Border::BORDER_THIN);

  //Set custom header name
  $activeSheet->setCellValue('A4','No.');
  $activeSheet->setCellValue('B4','Nama Agent');
  $activeSheet->setCellValue('C4','Piutang 3 Bulan Sebelum');
  $activeSheet->setCellValue('D4','Piutang Bulan '.$bulanLalu);
  $activeSheet->setCellValue('E4','Total Piutang sampai '.$bulanLalu);
  $activeSheet->setCellValue('F4','Fee 3 Bulan Sebelum');
  $activeSheet->setCellValue('G4','Fee Bulan '.$bulanLalu);
  $activeSheet->setCellValue('H4','Sisa Fee sampai '.$bulanLalu);
  $activeSheet->setCellValue('I4','BCA '.$bulanLalu);
  $activeSheet->setCellValue('J4','BRI '.$bulanLalu);
  
  $activeSheet->setCellValue('K4','Cash '.$bulanLalu);
  $activeSheet->setCellValue('L4','Sisa Piutang '.$bulanLalu);
  $activeSheet->setCellValue('M4','Pembayaran Fee '.$bulanLalu);
  $activeSheet->setCellValue('N4','Sisa Fee '.$bulanLalu);
  $activeSheet->setCellValue('O4','Total Payment '.$bulanLalu);
  
  $activeSheet->setCellValue('P4','Piutang '.$bulanSebelumnya);
  $activeSheet->setCellValue('Q4','Piutang EDC '.$bulanSebelumnya);
  $activeSheet->setCellValue('R4','Fee '.$bulanSebelumnya);
  $activeSheet->setCellValue('S4','BCA '.$bulanSebelumnya);
  $activeSheet->setCellValue('T4','BRI '.$bulanSebelumnya);
  
  $activeSheet->setCellValue('U4','Cash '.$bulanSebelumnya);
  $activeSheet->setCellValue('V4','Sisa Piutang '.$bulanSebelumnya);
  $activeSheet->setCellValue('W4','Pembayaran Fee '.$bulanSebelumnya);
  $activeSheet->setCellValue('X4','Sisa Fee '.$bulanSebelumnya);
  $activeSheet->setCellValue('Y4','Total Payment '.$bulanSebelumnya);
  
  $activeSheet->setCellValue('Z4','Piutang '.$bulanBerjalan);
  $activeSheet->setCellValue('AA4','Piutang EDC '.$bulanBerjalan);
  $activeSheet->setCellValue('AB4','Fee '.$bulanBerjalan);
  $activeSheet->setCellValue('AC4','BCA '.$bulanBerjalan);
  $activeSheet->setCellValue('AD4','BRI '.$bulanBerjalan);
  
  $activeSheet->setCellValue('AE4','Cash '.$bulanBerjalan);
  $activeSheet->setCellValue('AF4','Sisa Piutang '.$bulanBerjalan);
  $activeSheet->setCellValue('AG4','Pembayaran Fee '.$bulanBerjalan);
  $activeSheet->setCellValue('AH4','Sisa Fee '.$bulanBerjalan);
  $activeSheet->setCellValue('AI4','Total Payment '.$bulanBerjalan);
  
  $activeSheet->setCellValue('AJ4','Grand Total Sisa Fee');
  $activeSheet->setCellValue('AK4','Grand Total Payment');
  $activeSheet->setCellValue('AL4','Grand Total Pembayaran Fee');
  $activeSheet->setCellValue('AM4','Grand Total Sisa Piutang');
  

  $activeSheet->setCellValue('AN4','Nama Agent');
  $activeSheet->setCellValue('AO4','Sales');
  $activeSheet->setCellValue('AP4','Kolektor');
  
  
  //Set Font Style 00
  $activeSheet->getStyle('A4:BU4')->applyFromArray($boldFont);

  $activeSheet->getStyle('A4:D4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('89c765');
  
  //Header Red 00
   $activeSheet->getStyle('E4:E4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('fc3865');
  
  $activeSheet->getStyle('F4:O4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('89c765');
  
  $activeSheet->getStyle('L4:L4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('fc3865');
  
  $activeSheet->getStyle('P4:U4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('d49606');
  
   //Header Red
   $activeSheet->getStyle('V4:V4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('fc3865');
  
  $activeSheet->getStyle('W4:Y4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('d49606');
  
   $activeSheet->getStyle('Z4:Z4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('ff80ec');
  
   $activeSheet->getStyle('AA4:AE4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('ff80ec');
   //Header Red
   
  
  $activeSheet->getStyle('AG4:AP4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('ff80ec');
  
  
   //Header Red
   $activeSheet->getStyle('B4:B4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('00e1ff');
  
   //Header Red
   $activeSheet->getStyle('AN4:AN4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('00e1ff');
  
  
   //Header Red
   $activeSheet->getStyle('L4:L4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('fc3865');
  
  //Header Red
   $activeSheet->getStyle('AJ4:AM4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('fcdf03');
  
  $activeSheet->getStyle('AN4:AN4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('00e1ff');
  
  $activeSheet->getStyle('AJ4:AJ4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('fcba03');
  
  $activeSheet->getStyle('AK4:AK4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('00c907');
  
  $activeSheet->getStyle('AL4:AL4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('02e9ed');
  
  $activeSheet->getStyle('AF4:AF4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('fc3865');
  
  $activeSheet->getStyle('AM4:AM4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('fc3865');
  
  //Set Default Cell Style
  $activeSheet->getStyle('A5:AP'.$lastRow)->applyFromArray($defCellStyle);

  
  foreach($data as $key => $domain) {
      
    $row = (int)$key+5;
    $activeSheet->setCellValue('A'.$row, $key+1);
    
    $activeSheet->setCellValue('B'.$row, $domain['nama_agent']);
    $activeSheet->setCellValue('C'.$row, $domain['piutang_bulan_sebelum']);
    $activeSheet->setCellValue('D'.$row, $domain['piutang_bulan2']); 
    $activeSheet->setCellValue('E'.$row, $domain['total_piutang_bulan2']); 
    $activeSheet->getStyle('E'.$row)->applyFromArray($newRowStyleSanur);
    $activeSheet->setCellValue('F'.$row, $domain['komisi_bulan_sebelum']); 
    $activeSheet->setCellValue('G'.$row, $domain['komisi_bulan2']);
    $activeSheet->setCellValue('H'.$row, $domain['total_komisi_bulan2']); 
    $activeSheet->setCellValue('I'.$row, $domain['bca_bulan2']);
    $activeSheet->setCellValue('J'.$row, $domain['bri_bulan2']);
    
    $activeSheet->setCellValue('K'.$row, $domain['cash_bulan2']);
    $activeSheet->setCellValue('L'.$row, $domain['sisa_piutang_bulan2']); 
    $activeSheet->getStyle('L'.$row)->applyFromArray($newRowStyleSanur);
    $activeSheet->setCellValue('M'.$row, $domain['pembayaran_komisi_bulan2']);
    $activeSheet->setCellValue('N'.$row, $domain['sisa_komisi_bulan2']);
    $activeSheet->setCellValue('O'.$row, $domain['total_payment_bulan2']); 
    $activeSheet->setCellValue('P'.$row, $domain['piutang_bulan1']); 
    $activeSheet->getStyle('P'.$row)->applyFromArray($newRowStyleOrangeTua);
    
    $activeSheet->setCellValue('Q'.$row, $domain['piutang_edc_bulan1']); 
    $activeSheet->setCellValue('R'.$row, $domain['komisi_bulan1']);
    $activeSheet->setCellValue('S'.$row, $domain['bca_bulan1']); 
    $activeSheet->setCellValue('T'.$row, $domain['bri_bulan1']);
    $activeSheet->setCellValue('U'.$row, $domain['cash_bulan1']);
    $activeSheet->setCellValue('V'.$row, $domain['sisa_piutang_bulan1']);
    $activeSheet->getStyle('V'.$row)->applyFromArray($newRowStyleSanur);
    
    $activeSheet->setCellValue('W'.$row, $domain['total_komisi_bulan1']); 
    $activeSheet->setCellValue('X'.$row, $domain['sisa_komisi_bulan1']);
    $activeSheet->setCellValue('Y'.$row, $domain['total_payment_bulan1']);
    
    $activeSheet->setCellValue('Z'.$row, $domain['piutang_bulan0']); 
    $activeSheet->getStyle('Z'.$row)->applyFromArray($newRowStylePink);
    
    $activeSheet->setCellValue('AA'.$row, $domain['piutang_edc_bulan0']); 
    $activeSheet->setCellValue('AB'.$row, $domain['komisi_bulan0']); 
    $activeSheet->setCellValue('AC'.$row, $domain['bca_bulan0']);
    $activeSheet->setCellValue('AD'.$row, $domain['bri_bulan0']); 
    $activeSheet->setCellValue('AE'.$row, $domain['cash_bulan0']);
    $activeSheet->setCellValue('AF'.$row, $domain['sisa_piutang_bulan0']);
    $activeSheet->getStyle('AF'.$row)->applyFromArray($newRowStyleSanur);
    
    $activeSheet->setCellValue('AG'.$row, $domain['total_komisi_bulan0']);
    $activeSheet->setCellValue('AH'.$row, $domain['sisa_komisi_bulan0']); 
    $activeSheet->setCellValue('AI'.$row, $domain['total_payment_bulan0']);
    
    $activeSheet->setCellValue('AJ'.$row, $domain['sisa_komisi_bulan2'] + $domain['sisa_komisi_bulan1'] + $domain['sisa_komisi_bulan0']);
    $activeSheet->getStyle('AJ'.$row)->applyFromArray($newRowStyleKuning);
    
    $activeSheet->setCellValue('AK'.$row, $domain['total_payment_bulan2'] + $domain['total_payment_bulan1'] + $domain['total_payment_bulan0']); 
    $activeSheet->getStyle('AK'.$row)->applyFromArray($newRowStyleHijau);
    
    $activeSheet->setCellValue('AL'.$row, $domain['grand_total_pembayaran_komisi']); 
    $activeSheet->getStyle('AL'.$row)->applyFromArray($newRowStyleBiru);
    
    
    $activeSheet->setCellValue('AM'.$row, $domain['sisa_piutang_bulan2'] + $domain['sisa_piutang_bulan1'] + $domain['sisa_piutang_bulan0']); 
    
    $activeSheet->getStyle('AM'.$row)->applyFromArray($newRowStyleSanur);
    $activeSheet->setCellValue('AN'.$row, $domain['agent_kanan']);
    $activeSheet->setCellValue('AO'.$row, $domain['sales']);
    $activeSheet->setCellValue('AP'.$row, $domain['kolektor']);
    
    $TotalBCALalu = $TotalBCALalu + $domain['bca_bulan2'];
    $TotalBRILalu = $TotalBRILalu + $domain['bri_bulan2'];
    $TotalCashLalu = $TotalCashLalu + $domain['cash_bulan2'];
    
    $TotalBCAKemarin = $TotalBCAKemarin + $domain['bca_bulan1'];
    $TotalBRIKemarin = $TotalBRIKemarin + $domain['bri_bulan1'];
    $TotalCashKemarin = $TotalCashKemarin + $domain['cash_bulan1'];
    
    $TotalBCASekarang = $TotalBCASekarang + $domain['bca_bulan0'];
    $TotalBRISekarang = $TotalBRISekarang + $domain['bri_bulan0'];
    $TotalCashSekarang = $TotalCashSekarang + $domain['cash_bulan0'];
    
    $PiutangBulanLalu =  $PiutangBulanLalu + $domain['sisa_piutang_bulan2'];
    $PiutangBulanSebelum =  $PiutangBulanSebelum + $domain['sisa_piutang_bulan1'];
    $PiutangBulanBerjalan =  $PiutangBulanBerjalan + $domain['sisa_piutang_bulan0'];
    
    
    $FeeBulanLalu =  $FeeBulanLalu + $domain['sisa_komisi_bulan2'];
    $FeeBulanSebelum =  $FeeBulanSebelum + $domain['sisa_komisi_bulan1'];
    $FeeBulanBerjalan =  $FeeBulanBerjalan + $domain['sisa_komisi_bulan0'];
    
    
  }

  $newRowStyle = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => 'f79448'
        ]
    ]
);

  $newRow = $lastRow+1;
  $activeSheet->setCellValue('A'.$newRow, 'TOTAL');
  $activeSheet->mergeCells('A'.$newRow. ':C'.$newRow);
  $activeSheet->getStyle('A'.$newRow)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$newRow)->applyFromArray($newRowStyle);

  //insert sum on cells H9:AD9, eg H9=sum(H5:H8)
  foreach (range('C','Z') as $cell) {
    $activeSheet->setCellValue($cell.$newRow, '=SUM('.$cell.'5:' .$cell.$lastRow .')');
    $activeSheet->getStyle($cell.$newRow)->applyFromArray($newRowStyle);
    
    $activeSheet->getStyle('C'.$newRow)->applyFromArray($newRowStyleHijau);
    $activeSheet->getStyle('D'.$newRow)->applyFromArray($newRowStyleHijau);
    
    $activeSheet->getStyle('E'.$newRow)->applyFromArray($newRowStyleSanur);
    
    $activeSheet->getStyle('F'.$newRow)->applyFromArray($newRowStyleHijau);
    $activeSheet->getStyle('G'.$newRow)->applyFromArray($newRowStyleHijau);
    $activeSheet->getStyle('H'.$newRow)->applyFromArray($newRowStyleHijau);
    $activeSheet->getStyle('I'.$newRow)->applyFromArray($newRowStyleHijau);
    $activeSheet->getStyle('J'.$newRow)->applyFromArray($newRowStyleHijau);
    $activeSheet->getStyle('K'.$newRow)->applyFromArray($newRowStyleHijau);
    
    $activeSheet->getStyle('L'.$newRow)->applyFromArray($newRowStyleSanur);
    
    $activeSheet->getStyle('P'.$newRow)->applyFromArray($newRowStyleOrangeTua);
    $activeSheet->getStyle('Q'.$newRow)->applyFromArray($newRowStyleOrangeTua);
    $activeSheet->getStyle('R'.$newRow)->applyFromArray($newRowStyleOrangeTua);
    $activeSheet->getStyle('S'.$newRow)->applyFromArray($newRowStyleOrangeTua);
    $activeSheet->getStyle('T'.$newRow)->applyFromArray($newRowStyleOrangeTua);
    $activeSheet->getStyle('U'.$newRow)->applyFromArray($newRowStyleOrangeTua);
    
    
    $activeSheet->getStyle('V'.$newRow)->applyFromArray($newRowStyleSanur);
    
    $activeSheet->getStyle('W'.$newRow)->applyFromArray($newRowStyleOrangeTua);
    $activeSheet->getStyle('X'.$newRow)->applyFromArray($newRowStyleOrangeTua);
    $activeSheet->getStyle('Y'.$newRow)->applyFromArray($newRowStyleOrangeTua);
    
    $activeSheet->getStyle('Z'.$newRow)->applyFromArray($newRowStylePink);
    
  
  foreach (range('A','P') as $cell) {
    $activeSheet->setCellValue('A'.$cell.$newRow, '=SUM(A'.$cell.'5:A' .$cell.$lastRow .')');
    $activeSheet->getStyle('A'.$cell.$newRow)->applyFromArray($newRowStyle);
    
    $activeSheet->getStyle('AA'.$newRow)->applyFromArray($newRowStylePink);
    $activeSheet->getStyle('AB'.$newRow)->applyFromArray($newRowStylePink);
    $activeSheet->getStyle('AC'.$newRow)->applyFromArray($newRowStylePink);
    $activeSheet->getStyle('AD'.$newRow)->applyFromArray($newRowStylePink);
    $activeSheet->getStyle('AE'.$newRow)->applyFromArray($newRowStylePink);
    
    $activeSheet->getStyle('AF'.$newRow)->applyFromArray($newRowStyleSanur);
    
    $activeSheet->getStyle('AG'.$newRow)->applyFromArray($newRowStylePink);
    $activeSheet->getStyle('AH'.$newRow)->applyFromArray($newRowStylePink);
    $activeSheet->getStyle('AI'.$newRow)->applyFromArray($newRowStylePink);
    
    $activeSheet->getStyle('AJ'.$newRow)->applyFromArray($newRowStyleKuning);
    $activeSheet->getStyle('AK'.$newRow)->applyFromArray($newRowStyleHijau);
    $activeSheet->getStyle('AL'.$newRow)->applyFromArray($newRowStyleBiru);
    
    $activeSheet->getStyle('AM'.$newRow)->applyFromArray($newRowStyleSanur);
  }
  }

  
  //set number format
  $activeSheet->getStyle('C5:AR'.$newRow)->getNumberFormat()
  ->setFormatCode('#,##0');
  
  $activeSheet->freezePane("C2");
  $activeSheet->getColumnDimension('Q')->setVisible(false);
  $activeSheet->getColumnDimension('AA')->setVisible(false);
  
  //Resume HEADER -----------------------------------------------
 
 
  // Redirect output to a client's web browser (Xlsx)
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment;filename="webstats.xlsx"');
  header('Cache-Control: max-age=0');
  
  $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
  $writer->save('laporan-piutang_'. $date .'.xlsx');
  //exit;
}

function make_empty_spreadsheet($headerText, $date){
  $spreadsheet = new Spreadsheet();
  $activeSheet = $spreadsheet->getActiveSheet();
  $activeSheet->setTitle('Laporan Piutang');
  $activeSheet->getParent()->getDefaultStyle()->getFont()->setName('Times New Roman');
  $activeSheet->setCellValue('A1', $headerText);
  $activeSheet->getStyle("A1")->getFont()->setSize(16);

  $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
  $writer->save('laporan-piutang_'. $date .'.xlsx');
  //exit;
}


function send_daily_report($date){
  $file = "laporan-piutang_". $date .".xlsx";
  $mimetype = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
  $encoding = 'base64';
  
  $mail = new PHPMailer(); // create a new object
  $mail->IsSMTP(); // enable SMTP
  $mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
  $mail->SMTPAuth = true; // authentication enabled
  $mail->SMTPSecure = 'ssl'; // secure transfer enabled REQUIRED for Gmail
  $mail->Host = "smtp.gmail.com";
  $mail->Port = 465; // or 587
  $mail->IsHTML(true);
  $mail->Username = "system.dcamel@gmail.com";
  $mail->Password = "Kita@20190";
  $mail->SetFrom("system.dcamel@gmail.com");
  $mail->Subject = "Laporan Piutang ". $date;
  $mail->Body = "Lihat Lampiran";
  
  //$mail->AddAddress("laporandcamel@gmail.com");
  $mail->AddAddress("muriarka.gede@gmail.com");
  
  //$mail->AddCC("accounting@dcamelfastferry.com");
  //$mail->AddCC("accounting3@dcamelfastferry.com");
  
  $mail->addAttachment($file, $file, $encoding, $mimetype);

  if(!$mail->Send()) {
      echo "Mailer Error: " . $mail->ErrorInfo;
  } else {
      echo "Message has been sent";
  }
}

?>
