<?php
 
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
 
require_once 'vendor/autoload.php';
require_once 'conn.php';

$Cargonya=0;
$stmt = $pdo->prepare("select * from v_cargo where month(depart_date) = month(now()) and year(depart_date) = year(now())");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    $Cargonya = $Cargonya + $row['nominal_cargo'];
}


$stmt = $pdo->prepare("select depart_date, sum(nominal_activity) as nominal_activity, sum(nominal_hotel) as nominal_hotel, 
sum(nominal_activity + nominal_hotel) as 'HotelAc' from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now())");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    $xnominal_activity = $xnominal_activity + $row['nominal_activity'];
    $xnominal_hotel = $xnominal_hotel + $row['nominal_hotel'];
    $HotelAc = $HotelAc + $row['HotelAc'];
}



//Cari Cash Sanur dan Lembongan 
$CashSanur=0;
$CashLembongan=0;
$i=0;
$stmt = $pdo->prepare("select depart_from, sum(nominal_collect_cash) as jum from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now()) group by depart_from order by depart_from");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    if ($i==0)
    {
        $CashLembongan = $row['jum'];
    }
    else
    {
        $CashSanur = $row['jum'];
    }
    $i++;
}



//Cari EDC Sanur dan Lembongan 
$EDCSanur=0;
$EDCLembongan=0;
$i=0;
$stmt = $pdo->prepare("select depart_from, sum(nominal_collect_BCA + nominal_collect_BRI) as jum from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now()) group by depart_from order by depart_from");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    if ($i==0)
    {
        $EDCLembongan = $row['jum'];
    }
    else
    {
        $EDCSanur = $row['jum'];
    }
    $i++;
}


//Cari Account Sanur dan Lembongan 
$AccountSanur=0;
$AccountLembongan=0;
$i=0;
$stmt = $pdo->prepare("select depart_from, sum(nominal_account + InvoicePayment_Cash + InvoicePayment_BCA + InvoicePayment_BRI) as jum from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now()) group by depart_from order by depart_from");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    if ($i==0)
    {
        $AccountLembongan = $row['jum'];
    }
    else
    {
        $AccountSanur = $row['jum'];
    }
    $i++;
}

//Cari DP Cash Sanur dan Lembongan 
$DPCashSanur=0;
$DPCashLembongan=0;
$i=0;
$stmt = $pdo->prepare("select depart_from, sum(nominal_deposit) as jum from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now()) group by depart_from order by depart_from");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    if ($i==0)
    {
        $DPCashLembongan = $row['jum'];
    }
    else
    {
        $DPCashSanur = $row['jum'];
    }
    $i++;
}

//Cari DP BCA Sanur dan Lembongan 
$DPBCASanur=0;
$DPBCALembongan=0;
$i=0;
$stmt = $pdo->prepare("select depart_from, sum(nominal_deposit_BCA) as jum from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now()) group by depart_from order by depart_from");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    if ($i==0)
    {
        $DPBCALembongan = $row['jum'];
    }
    else
    {
        $DPBCASanur = $row['jum'];
    }
    $i++;
}


//Cari DP BRI Sanur dan Lembongan 
$DPBRISanur=0;
$DPBRILembongan=0;
$i=0;
$stmt = $pdo->prepare("select depart_from, sum(nominal_deposit_BRI) as jum from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now()) group by depart_from order by depart_from");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    if ($i==0)
    {
        $DPBRILembongan = $row['jum'];
    }
    else
    {
        $DPBRISanur = $row['jum'];
    }
    $i++;
}



$today = date("Y-m-d");

$query = "select aa.*, bb.TotalBruto,bb.TotalKomisi, bb.TotalDPBCA, bb.TotalDepositBRI, bb.TotalNet, bb.TotalAccount from v_bruto aa, 
view_resume_bruto bb where aa.depart_date = bb.depart_date";
$stmt = $pdo->prepare($query);
$stmt->execute();
$data_laporan = $stmt->fetchAll(PDO::FETCH_ASSOC);
$totalRow = count($data_laporan);

if(empty($data_laporan)){
  make_empty_spreadsheet("There is nothing to report today", $today);
  send_daily_report($today);
}else {
  make_spreadsheet("Laporan Bruto", $data_laporan, $today, $totalRow, $Cargonya, $xnominal_hotel, 
        $xnominal_activity, $HotelAc, $CashLembongan, $CashSanur, $EDCLembongan, $EDCSanur, $AccountLembongan, $AccountSanur, $DPCashLembongan, 
        $DPCashSanur, $DPBCALembongan, $DPBCASanur, $DPBRILembongan, $DPBRISanur);
  send_daily_report($today);
}

// Create new Spreadsheet object

function make_spreadsheet($headerText, $data, $date, $totalRow, $xCargo, $xHotel, $xActivity, 
        $xHC, $CashLembongan, $CashSanur, $EDCLembongan, $EDCSanur, $AccountLembongan, $AccountSanur, $DPCashLembongan, $DPCashSanur, 
        $DPBCALembongan, $DPBCASanur, $DPBRILembongan, $DPBRISanur){
  $spreadsheet = new Spreadsheet();
  $activeSheet = $spreadsheet->getActiveSheet();
  $activeSheet->setTitle('Laporan Bruto');
  $activeSheet->getParent()->getDefaultStyle()->getFont()->setName('Noto Sans');
  $activeSheet->getDefaultRowDimension()->setRowHeight(35);
  $lastRow = $totalRow+4;

  
  $boldFont = array(
      'font' => [
        'bold' => true,
      ],

      'alignment' => [
          'horizontal' => Alignment::HORIZONTAL_CENTER,
          'vertical' => Alignment::VERTICAL_CENTER
      ],

      'borders' => [
        'vertical' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
        ],
        'top' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
        ]
      ]
  );

  $defCellStyle = array(
    'alignment' => [
      'horizontal' => Alignment::HORIZONTAL_CENTER,
      'vertical' => Alignment::VERTICAL_TOP
    ],

    'borders' => [
      'vertical' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
      ],
    ]
  );

  $activeSheet->setCellValue('A1', $headerText);
  $activeSheet->getStyle("A1")->getFont()->setSize(16);

  // Auto Width Default
  foreach (range('A','Z') as $cell) {
    $activeSheet->getColumnDimension($cell)->setAutoSize(true);
  }

  foreach (range('A','Z') as $cell) {
    $activeSheet->getColumnDimension('A'.$cell)->setAutoSize(true);
  }
  
  foreach (range('A','Z') as $cell) {
    $activeSheet->getColumnDimension('B'.$cell)->setAutoSize(true);
  }
  
  //custom last header style (border workaround)
  $activeSheet->getStyle('BE3')
  ->getBorders()->getRight()
  ->setBorderStyle(Border::BORDER_THIN);
  $activeSheet->getStyle('BE4')
  ->getBorders()->getRight()
  ->setBorderStyle(Border::BORDER_THIN);

  //Set custom header name
  $activeSheet->setCellValue('A4','No.');
  
  $activeSheet->setCellValue('B4','Tanggal');
  $activeSheet->setCellValue('C4','Time');
  $activeSheet->setCellValue('D4','Collect Cash');
  $activeSheet->setCellValue('E4','EDC');
  $activeSheet->setCellValue('F4','Komisi');
  $activeSheet->setCellValue('G4','DP Cash');
  $activeSheet->setCellValue('H4','DP BCA');
  $activeSheet->setCellValue('I4','DP BRI');
  
  $activeSheet->setCellValue('J4','Time');
  $activeSheet->setCellValue('K4','Collect Cash');
  $activeSheet->setCellValue('L4','EDC');
  $activeSheet->setCellValue('M4','Komisi');
  $activeSheet->setCellValue('N4','DP Cash');
  $activeSheet->setCellValue('O4','DP BCA');
  $activeSheet->setCellValue('P4','DP BRI');

  $activeSheet->setCellValue('Q4','Time');
  $activeSheet->setCellValue('R4','Collect Cash');
  $activeSheet->setCellValue('S4','EDC');
  $activeSheet->setCellValue('T4','Komisi');
  $activeSheet->setCellValue('U4','DP Cash');
  $activeSheet->setCellValue('V4','DP BCA');
  $activeSheet->setCellValue('W4','DP BRI');
  
  $activeSheet->setCellValue('X4','Time');
  $activeSheet->setCellValue('Y4','Collect Cash');
  $activeSheet->setCellValue('Z4','EDC');
  $activeSheet->setCellValue('AA4','Komisi');
  $activeSheet->setCellValue('AB4','DP Cash');
  $activeSheet->setCellValue('AC4','DP BCA');
  $activeSheet->setCellValue('AD4','DP BRI');
  
  $activeSheet->setCellValue('AE4','Time');
  $activeSheet->setCellValue('AF4','Collect Cash');
  $activeSheet->setCellValue('AG4','EDC');
  $activeSheet->setCellValue('AH4','Komisi');
  $activeSheet->setCellValue('AI4','DP Cash');
  $activeSheet->setCellValue('AJ4','DP BCA');
  $activeSheet->setCellValue('AK4','DP BRI');
  
  $activeSheet->setCellValue('AL4','Time');
  $activeSheet->setCellValue('AM4','Collect Cash');
  $activeSheet->setCellValue('AN4','EDC');
  $activeSheet->setCellValue('AO4','Komisi');
  $activeSheet->setCellValue('AP4','DP Cash');
  $activeSheet->setCellValue('AQ4','DP BCA');
  $activeSheet->setCellValue('AR4','DP BRI');
  
  $activeSheet->setCellValue('AS4','Time');
  $activeSheet->setCellValue('AT4','Collect Cash');
  $activeSheet->setCellValue('AU4','EDC');
  $activeSheet->setCellValue('AV4','Komisi');
  $activeSheet->setCellValue('AW4','DP Cash');
  $activeSheet->setCellValue('AX4','DP BCA');
  $activeSheet->setCellValue('AY4','DP BRI');
  
  $activeSheet->setCellValue('AZ4','Total Bruto');
  $activeSheet->setCellValue('BA4','Total Komisi');
  $activeSheet->setCellValue('BB4','Total DP BCA');
  $activeSheet->setCellValue('BC4','Total DP BRI');
  $activeSheet->setCellValue('BD4','Total Net');
  $activeSheet->setCellValue('BE4','Total Account');
  
  //Set Font Style
  $activeSheet->getStyle('A4:BE4')->applyFromArray($boldFont);

  $activeSheet->getStyle('A4:BE4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('89c765');
  
  //Set Default Cell Style
  $activeSheet->getStyle('A5:BE'.$lastRow)->applyFromArray($defCellStyle);

  
  foreach($data as $key => $domain) {
    $row = (int)$key+5;
    $activeSheet->setCellValue('A'.$row, $key+1);
    $activeSheet->setCellValue('B'.$row, $domain['depart_date']);
    $activeSheet->setCellValue('C'.$row, $domain['depart_time']);
    $activeSheet->setCellValue('D'.$row, $domain['collectcash']);
    $activeSheet->setCellValue('E'.$row, $domain['EDC']); 
    $activeSheet->setCellValue('F'.$row, $domain['komisi']); 
    $activeSheet->setCellValue('G'.$row, $domain['DPCash']); 
    $activeSheet->setCellValue('H'.$row, $domain['DPBCA']);
    $activeSheet->setCellValue('I'.$row, $domain['DPBRI']); 
    
    $activeSheet->setCellValue('J'.$row, $domain['depart_time0930']);
    $activeSheet->setCellValue('K'.$row, $domain['collectcash0930']);
    $activeSheet->setCellValue('L'.$row, $domain['EDC0930']);
    $activeSheet->setCellValue('M'.$row, $domain['komisi0930']); 
    $activeSheet->setCellValue('N'.$row, $domain['DPCash0930']); 
    $activeSheet->setCellValue('O'.$row, $domain['DPBCA0930']); 
    $activeSheet->setCellValue('P'.$row, $domain['DPBRI0930']);
    
    $activeSheet->setCellValue('Q'.$row, $domain['depart_time1230']);
    $activeSheet->setCellValue('R'.$row, $domain['collectcash1230']);
    $activeSheet->setCellValue('S'.$row, $domain['EDC1230']);
    $activeSheet->setCellValue('T'.$row, $domain['komisi1230']); 
    $activeSheet->setCellValue('U'.$row, $domain['DPCash1230']); 
    $activeSheet->setCellValue('V'.$row, $domain['DPBCA1230']); 
    $activeSheet->setCellValue('W'.$row, $domain['DPBRI1230']);
    
    $activeSheet->setCellValue('X'.$row, $domain['depart_time1400']);
    $activeSheet->setCellValue('Y'.$row, $domain['collectcash1400']);
    $activeSheet->setCellValue('Z'.$row, $domain['EDC1400']);
    $activeSheet->setCellValue('AA'.$row, $domain['komisi1400']); 
    $activeSheet->setCellValue('AB'.$row, $domain['DPCash1400']); 
    $activeSheet->setCellValue('AC'.$row, $domain['DPBCA1400']); 
    $activeSheet->setCellValue('AD'.$row, $domain['DPBRI1400']);
    
    $activeSheet->setCellValue('AE'.$row, $domain['depart_time1400']);
    $activeSheet->setCellValue('AF'.$row, $domain['collectcash1400']);
    $activeSheet->setCellValue('AG'.$row, $domain['EDC1400']);
    $activeSheet->setCellValue('AH'.$row, $domain['komisi1400']); 
    $activeSheet->setCellValue('AI'.$row, $domain['DPCash1400']); 
    $activeSheet->setCellValue('AJ'.$row, $domain['DPBCA1400']); 
    $activeSheet->setCellValue('AK'.$row, $domain['DPBRI1400']);
    
    $activeSheet->setCellValue('AL'.$row, $domain['depart_time1600']);
    $activeSheet->setCellValue('AM'.$row, $domain['collectcash1600']);
    $activeSheet->setCellValue('AN'.$row, $domain['EDC1600']);
    $activeSheet->setCellValue('AO'.$row, $domain['komisi1600']); 
    $activeSheet->setCellValue('AP'.$row, $domain['DPCash1600']); 
    $activeSheet->setCellValue('AQ'.$row, $domain['DPBCA1600']); 
    $activeSheet->setCellValue('AR'.$row, $domain['DPBRI1600']);
    
    $activeSheet->setCellValue('AS'.$row, $domain['depart_time1700']);
    $activeSheet->setCellValue('AT'.$row, $domain['collectcash1700']);
    $activeSheet->setCellValue('AU'.$row, $domain['EDC1700']);
    $activeSheet->setCellValue('AV'.$row, $domain['komisi1700']); 
    $activeSheet->setCellValue('AW'.$row, $domain['DPCash1700']); 
    $activeSheet->setCellValue('AX'.$row, $domain['DPBCA1700']); 
    $activeSheet->setCellValue('AY'.$row, $domain['DPBRI1700']);
    
    $activeSheet->setCellValue('AZ'.$row, $domain['TotalBruto']);
    $activeSheet->setCellValue('BA'.$row, $domain['TotalKomisi']);
    $activeSheet->setCellValue('BB'.$row, $domain['TotalDPBCA']); 
    $activeSheet->setCellValue('BC'.$row, $domain['TotalDepositBRI']); 
    $activeSheet->setCellValue('BD'.$row, $domain['TotalNet']); 
    $activeSheet->setCellValue('BE'.$row, $domain['TotalAccount']);
    
  }

  $newRowStyle = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => 'f79448'
        ]
    ]
);

  $newRow = $lastRow+1;
  $activeSheet->setCellValue('A'.$newRow, 'TOTAL');
  $activeSheet->mergeCells('A'.$newRow. ':C'.$newRow);
  $activeSheet->getStyle('A'.$newRow)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$newRow)->applyFromArray($newRowStyle);

  //insert sum on cells H9:AD9, eg H9=sum(H5:H8)
  foreach (range('C','Z') as $cell) {
    $activeSheet->setCellValue($cell.$newRow, '=SUM('.$cell.'5:' .$cell.$lastRow .')');
    $activeSheet->getStyle($cell.$newRow)->applyFromArray($newRowStyle);
  }
  
  foreach (range('A','Z') as $cell) {
    $activeSheet->setCellValue('A'.$cell.$newRow, '=SUM(A'.$cell.'5:A' .$cell.$lastRow .')');
    $activeSheet->getStyle('A'.$cell.$newRow)->applyFromArray($newRowStyle);
  }
  
  foreach (range('A','E') as $cell) {
    $activeSheet->setCellValue('B'.$cell.$newRow, '=SUM(B'.$cell.'5:B' .$cell.$lastRow .')');
    $activeSheet->getStyle('B'.$cell.$newRow)->applyFromArray($newRowStyle);
  }
  
  //set number format
  $activeSheet->getStyle('D5:BE'.$newRow)->getNumberFormat()
  ->setFormatCode('#,##0');
  
  
  //Resume
  $barisBaru = $lastRow+3;
  $activeSheet->setCellValue('B'.$barisBaru, 'LEMBONGAN');
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('C'.$barisBaru, 'SANUR');
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('D'.$barisBaru, 'TOTAL');
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  
  //Total Cash Sanur Lembongan -----------------------------------------
  $barisBaru = $lastRow+4;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL CASH');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $CashLembongan);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('C'.$barisBaru, $CashSanur);
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('C'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('D'.$barisBaru, $CashSanur+$CashLembongan);
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('D'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  //Total Cash Sanur Lembongan -----------------------------------------
  
  
  
  //Total EDC Sanur Lembongan -----------------------------------------
  $barisBaru = $lastRow+5;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL EDC - MASUK MUTASI');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $EDCLembongan);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('C'.$barisBaru, $EDCSanur);
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('C'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('D'.$barisBaru, $EDCSanur + $EDCLembongan);
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('D'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  //Total EDC Sanur Lembongan -----------------------------------------
  
  //Total Account Sanur Lembongan ----------------------------------------- 
  $barisBaru = $lastRow+6;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL ACCT/VCR');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $AccountLembongan);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('C'.$barisBaru, $AccountSanur);
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('C'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('D'.$barisBaru, $AccountSanur + $AccountLembongan);
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('D'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  //Total Account Sanur Lembongan -----------------------------------------
  
  //Total DP Cash Sanur Lembongan ----------------------------------------- 
  $barisBaru = $lastRow+7;
  $activeSheet->setCellValue('A'.$barisBaru, 'DEPOSIT CASH');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $DPCashLembongan);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('C'.$barisBaru, $DPCashSanur);
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('C'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('D'.$barisBaru, $DPCashSanur + $DPCashLembongan);
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('D'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  //Total DP Cash Sanur Lembongan -----------------------------------------
  
  
  //Total DP BCA Sanur Lembongan -----------------------------------------
  $barisBaru = $lastRow+8;
  $activeSheet->setCellValue('A'.$barisBaru, 'DEPOSIT BCA');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $DPBCALembongan);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('C'.$barisBaru, $DPBCASanur);
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('C'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('D'.$barisBaru, $DPBCASanur + $DPBCALembongan);
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('D'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  //Total DP BCA Sanur Lembongan -----------------------------------------
  
  //Total DP BRI Sanur Lembongan -----------------------------------------
  $barisBaru = $lastRow+9;
  $activeSheet->setCellValue('A'.$barisBaru, 'DEPOSIT BRI');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $DPBRILembongan);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('C'.$barisBaru, $DPBRISanur);
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('C'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('D'.$barisBaru, $DPBRISanur + $DPBRILembongan);
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('D'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  //Total DP BRI Sanur Lembongan -----------------------------------------
  
  
  //Total  Sanur Lembongan -----------------------------------------
  $barisBaru = $lastRow+10;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $CashLembongan +  $EDCLembongan +  $AccountLembongan + $DPCashLembongan + $DPBCALembongan + $DPBRILembongan);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('C'.$barisBaru, $CashSanur +  $EDCSanur +  $AccountSanur + $DPCashSanur + $DPBCASanur + $DPBRISanur);
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('C'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $activeSheet->setCellValue('D'.$barisBaru, $CashLembongan +  $EDCLembongan +  $AccountLembongan + $DPCashLembongan + $DPBCALembongan + $DPBRILembongan + $CashSanur +  $EDCSanur +  $AccountSanur + $DPCashSanur + $DPBCASanur + $DPBRISanur);
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('D'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  
  //Total  Sanur Lembongan -----------------------------------------
  
  $barisBaru = $lastRow+13;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL CARGO');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $xCargo);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $barisBaru = $lastRow+14;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL ACTIVITY');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $xActivity);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $barisBaru = $lastRow+15;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL HOTEL');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $xHotel);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $barisBaru = $lastRow+16;
  $activeSheet->setCellValue('A'.$barisBaru, 'HOTEL +  ACTIVITY');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $xHC);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  
  // Redirect output to a client's web browser (Xlsx)
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment;filename="webstats.xlsx"');
  header('Cache-Control: max-age=0');
  
  $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
  $writer->save('laporan-bruto_'. $date .'.xlsx');
  //exit;
}

function make_empty_spreadsheet($headerText, $date){
  $spreadsheet = new Spreadsheet();
  $activeSheet = $spreadsheet->getActiveSheet();
  $activeSheet->setTitle('Laporan Bruto');
  $activeSheet->getParent()->getDefaultStyle()->getFont()->setName('Times New Roman');
  $activeSheet->setCellValue('A1', $headerText);
  $activeSheet->getStyle("A1")->getFont()->setSize(16);

  $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
  $writer->save('laporan-bruto_'. $date .'.xlsx');
  //exit;
}

function send_daily_report($date){
  $file = "laporan-bruto_". $date .".xlsx";
  $mimetype = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
  $encoding = 'base64';
  
  $mail = new PHPMailer(); // create a new object
  $mail->IsSMTP(); // enable SMTP
  $mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
  $mail->SMTPAuth = true; // authentication enabled
  $mail->SMTPSecure = 'ssl'; // secure transfer enabled REQUIRED for Gmail
  $mail->Host = "smtp.gmail.com";
  $mail->Port = 465; // or 587
  $mail->IsHTML(true);
  $mail->Username = "system.dcamel@gmail.com";
  $mail->Password = "Kita@20190";
  $mail->SetFrom("system.dcamel@gmail.com");
  $mail->Subject = "Laporan Bruto ". $date;
  $mail->Body = "Lihat Lampiran";
  
  $mail->AddAddress("laporandcamel@gmail.com");
  $mail->AddCC("muriarka.gede@gmail.com");
  
  $mail->AddCC("accounting@dcamelfastferry.com");

  
  $mail->addAttachment($file, $file, $encoding, $mimetype);

  if(!$mail->Send()) {
      echo "Mailer Error: " . $mail->ErrorInfo;
  } else {
      echo "Message has been sent";
  }
}

?>
