<?php
 
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
 
require_once 'vendor/autoload.php';
require_once 'conn.php';

$today = date("Y-m-d");

$query = "select WNA_Adult AS 'NO', 
                 depart_date AS 'Depart Date',
                 depart_time AS 'Depart Time',
                 guest_name AS 'Guest Name',
                 ticket_number AS 'Ticket Number', 
                 type_trip AS 'Type Trip', 
                 agent,  
                 WNA_Adult AS 'WNA Adult', 
                 WNA_Child AS 'WNA Child', 
                 WNI_Adult AS 'WNI Adult',
                 WNI_Child AS 'WNI Child', 
                 FOC, 
                 Guide, 
                 Infant, 
                 Cargo,
                 nominal_boat,
                 nominal_activity,
                 nominal_hotel,
                 nominal_cargo,
                 nominal_extra_charge,
                 nominal_additional,
                 nominal_cancellatin_fee,
                 nominal_total_price,
                 nominal_deposit,
                 nominal_deposit_BCA,
                 nominal_deposit_BRI,
                 nominal_collect_cash,
                 nominal_collect_BCA,
                 nominal_collect_BRI,
                 nominal_account,
                 nominal_fee
            from sysoffice_pendapatan where depart_date = '$today' order by depart_time, ticket_number ";
$stmt = $pdo->prepare($query);
$stmt->execute();
$data_laporan = $stmt->fetchAll(PDO::FETCH_ASSOC);
$totalRow = count($data_laporan);

if(empty($data_laporan)){
  make_empty_spreadsheet("There is nothing to report today", $today);
  send_daily_report($today);
}else {
  make_spreadsheet("Laporan Harian", $data_laporan, $today, $totalRow);
  send_daily_report($today);
}

// Create new Spreadsheet object

function make_spreadsheet($headerText, $data, $date, $totalRow){
  $spreadsheet = new Spreadsheet();
  $activeSheet = $spreadsheet->getActiveSheet();
  $activeSheet->setTitle('Laporan Harian');
  $activeSheet->getParent()->getDefaultStyle()->getFont()->setName('Noto Sans');
  $activeSheet->getDefaultRowDimension()->setRowHeight(35);
  $lastRow = $totalRow+4;

  $boldFont = array(
      'font' => [
        'bold' => true,
      ],

      'alignment' => [
          'horizontal' => Alignment::HORIZONTAL_CENTER,
          'vertical' => Alignment::VERTICAL_CENTER
      ],

      'borders' => [
        'vertical' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
        ],
        'top' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
        ]
      ]
  );

  $defCellStyle = array(
    'alignment' => [
      'horizontal' => Alignment::HORIZONTAL_CENTER,
      'vertical' => Alignment::VERTICAL_TOP
    ],

    'borders' => [
      'vertical' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
      ],
    ]
  );

  $activeSheet->setCellValue('A1', $headerText);
  $activeSheet->getStyle("A1")->getFont()->setSize(16);
  $activeSheet->mergeCells('A1:D1');

  // Auto Width Default
  $activeSheet->getColumnDimension('A')->setAutoSize(true);
  $activeSheet->getColumnDimension('D')->setAutoSize(true);
  foreach (range('O','Z') as $cell) {
    $activeSheet->getColumnDimension($cell)->setAutoSize(true);
  }
  foreach (range('A','E') as $cell) {
    $activeSheet->getColumnDimension('A'.$cell)->setAutoSize(true);
  }

  //output headers
  $activeSheet->fromArray(array_keys($data[0]), NULL, 'A3');
  $activeSheet->fromArray(array_keys($data[0]), NULL, 'A4');
  $activeSheet->getRowDimension('4')->setRowHeight(30);

  //custom last header style (border workaround)
  $activeSheet->getStyle('AE3')
  ->getBorders()->getRight()
  ->setBorderStyle(Border::BORDER_THIN);
  $activeSheet->getStyle('AE4')
  ->getBorders()->getRight()
  ->setBorderStyle(Border::BORDER_THIN);

  //Set custom header name
  $activeSheet->setCellValue('P4','Boat');
  $activeSheet->setCellValue('Q4','Activity');
  $activeSheet->setCellValue('R4','Hotel');
  $activeSheet->setCellValue('S4','Cargo');

  $activeSheet->setCellValue('T4','Extra Charge');
  $activeSheet->setCellValue('U4','Additional');
  $activeSheet->setCellValue('V4','Cancelation');
  $activeSheet->setCellValue('W4','Total Price');

  $activeSheet->setCellValue('X4','Deposit Cach');
  $activeSheet->setCellValue('Y4','Deposit BCA');
  $activeSheet->setCellValue('Z4','Deposit BRI');
  
  $activeSheet->setCellValue('AA4','Collect Cash');
  $activeSheet->setCellValue('AB4','Collect BCA');
  $activeSheet->setCellValue('AC4','Collect BRI');
  
  $activeSheet->setCellValue('AD4','Nominal Account');
  $activeSheet->setCellValue('AE4','Nominal Fee');
  
  //merge cells for header
  $columns = range('A','G');
  foreach ($columns as $col) {
    $activeSheet->mergeCells($col.'3:' . $col.'4');
  }
  $activeSheet->mergeCells('H3:O3');
  $activeSheet->setCellValue('H3', "Pax Detail");
  
  $activeSheet->mergeCells('P3:AE3');
  $activeSheet->setCellValue('P3', "Nominal");
  

  // Set custom widtn and wrap text for column specified
  $columns = array('C');
  $columns = array_merge($columns, range('E','K'));
  foreach ($columns as $col) {
    $activeSheet->getColumnDimension($col)->setWidth(7);
    $activeSheet->getStyle($col.'3')->getAlignment()->setWrapText(true);
    $activeSheet->getStyle($col.'4')->getAlignment()->setWrapText(true);
  }

  $activeSheet->getColumnDimension('B')->setWidth(11);
  $activeSheet->getStyle('B3')->getAlignment()->setWrapText(true);

  foreach (range('E','G') as $col) {
    $activeSheet->getColumnDimension($col)->setWidth(10);
    $activeSheet->getStyle($col.'3')->getAlignment()->setWrapText(true);
    $activeSheet->getStyle($col)->getAlignment()->setWrapText(true);
  }
  

  //Set Font Style
  $activeSheet->getStyle('A4:AE4')->applyFromArray($boldFont);
  $activeSheet->getStyle('A3:AE3')->applyFromArray($boldFont);

  //set header color
  $activeSheet->getStyle('A3:AD3')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('59c5c7');
  $activeSheet->getStyle('H4:O4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('89c765');
  $activeSheet->getStyle('P4:AE4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('fff685');

  //Set Default Cell Style
  $activeSheet->getStyle('A5:AE'.$lastRow)->applyFromArray($defCellStyle);

  
  foreach($data as $key => $domain) {
    $row = (int)$key+5;
    $activeSheet->setCellValue('A'.$row, $key+1);
    $activeSheet->setCellValue('B'.$row, $domain['Depart Date']);
    $activeSheet->setCellValue('C'.$row, $domain['Depart Time']);
    $activeSheet->setCellValue('D'.$row, $domain['Guest Name']);
    $activeSheet->setCellValue('E'.$row, $domain['Ticket Number']); 
    $activeSheet->setCellValue('F'.$row, $domain['Type Trip']); 
    $activeSheet->setCellValue('G'.$row, $domain['agent']); 
    
    $activeSheet->setCellValue('H'.$row, $domain['WNA Adult']);
    $activeSheet->setCellValue('I'.$row, $domain['WNA Child']); 
    $activeSheet->setCellValue('J'.$row, $domain['WNI Adult']);
    $activeSheet->setCellValue('K'.$row, $domain['WNI Child']); 
    $activeSheet->setCellValue('L'.$row, $domain['FOC']); 
    $activeSheet->setCellValue('M'.$row, $domain['Guide']); 
    $activeSheet->setCellValue('N'.$row, $domain['Infant']);
    $activeSheet->setCellValue('O'.$row, $domain['Cargo']);
    
    $activeSheet->setCellValue('P'.$row, $domain['nominal_boat']);
    $activeSheet->setCellValue('Q'.$row, $domain['nominal_activity']);
    $activeSheet->setCellValue('R'.$row, $domain['nominal_hotel']);
    $activeSheet->setCellValue('S'.$row, $domain['nominal_cargo']);
    
    $activeSheet->setCellValue('T'.$row, $domain['nominal_extra_charge']);
    $activeSheet->setCellValue('U'.$row, $domain['nominal_additional']);
    $activeSheet->setCellValue('V'.$row, $domain['nominal_cancellatin_fee']);
    $activeSheet->setCellValue('W'.$row, $domain['nominal_total_price']);
    
    $activeSheet->setCellValue('X'.$row, $domain['nominal_deposit']);
    $activeSheet->setCellValue('Y'.$row, $domain['nominal_deposit_BCA']);
    $activeSheet->setCellValue('Z'.$row, $domain['nominal_deposit_BRI']);
    $activeSheet->setCellValue('AA'.$row, $domain['nominal_collect_cash']);
    
    $activeSheet->setCellValue('AB'.$row, $domain['nominal_collect_BCA']);
    $activeSheet->setCellValue('AC'.$row, $domain['nominal_collect_BRI']);
    $activeSheet->setCellValue('AD'.$row, $domain['nominal_account']);
    $activeSheet->setCellValue('AE'.$row, $domain['nominal_fee']);
  }

  //insert totals on the last row
  //merge A9:G9 insert TOTALS

  $newRowStyle = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => 'f79448'
        ]
    ]
);

  $newRow = $lastRow+1;
  $activeSheet->setCellValue('A'.$newRow, 'TOTAL');
  $activeSheet->mergeCells('A'.$newRow. ':G'.$newRow);
  $activeSheet->getStyle('A'.$newRow)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$newRow)->applyFromArray($newRowStyle);

  //insert sum on cells H9:AD9, eg H9=sum(H5:H8)
  foreach (range('H','Z') as $cell) {
    $activeSheet->setCellValue($cell.$newRow, '=SUM('.$cell.'5:' .$cell.$lastRow .')');
    $activeSheet->getStyle($cell.$newRow)->applyFromArray($newRowStyle);
  }
  foreach (range('A','E') as $cell) {
    $activeSheet->setCellValue('A'.$cell.$newRow, '=SUM(A'.$cell.'5:A' .$cell.$lastRow .')');
    $activeSheet->getStyle('A'.$cell.$newRow)->applyFromArray($newRowStyle);
  }

  //set number format
  $activeSheet->getStyle('O5:AE'.$newRow)->getNumberFormat()
  ->setFormatCode('#,##0');
  

  // Redirect output to a client's web browser (Xlsx)
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment;filename="webstats.xlsx"');
  header('Cache-Control: max-age=0');
  
  $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
  $writer->save('laporan-harian_'. $date .'.xlsx');
  //exit;
}

function make_empty_spreadsheet($headerText, $date){
  $spreadsheet = new Spreadsheet();
  $activeSheet = $spreadsheet->getActiveSheet();
  $activeSheet->setTitle('Laporan Pendapatan');
  $activeSheet->getParent()->getDefaultStyle()->getFont()->setName('Times New Roman');
  $activeSheet->setCellValue('A1', $headerText);
  $activeSheet->getStyle("A1")->getFont()->setSize(16);

  $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
  $writer->save('laporan-harian_'. $date .'.xlsx');
  //exit;
}

function send_daily_report($date){
  $file = "laporan-harian_". $date .".xlsx";
  $mimetype = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
  $encoding = 'base64';
  
  $mail = new PHPMailer(); // create a new object
  $mail->IsSMTP(); // enable SMTP
  $mail->SMTPDebug = 1; // debugging: 1 = errors and messages, 2 = messages only
  $mail->SMTPAuth = true; // authentication enabled
  $mail->SMTPSecure = 'ssl'; // secure transfer enabled REQUIRED for Gmail
  $mail->Host = "smtp.gmail.com";
  $mail->Port = 465; // or 587
  $mail->IsHTML(true);
  $mail->Username = "system.dcamel@gmail.com";
  $mail->Password = "Kita@20190";
  $mail->SetFrom("system.dcamel@gmail.com");
  $mail->Subject = "Laporan Harian Dcamelsys ". $date;
  $mail->Body = "Lihat Lampiran";
  
  $mail->AddAddress("laporandcamel@gmail.com");
  
  $mail->addAttachment($file, $file, $encoding, $mimetype);

  if(!$mail->Send()) {
      echo "Mailer Error: " . $mail->ErrorInfo;
  } else {
      echo "Message has been sent";
  }
}

?>
