<?php
 
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
 
require_once 'vendor/autoload.php';
require_once 'conn.php';


$Cargonya=0;
$stmt = $pdo->prepare("select * from v_cargo where month(depart_date) = month(now()) and year(depart_date) = year(now())");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    $Cargonya = $Cargonya + $row['nominal_cargo'];
}


$stmt = $pdo->prepare("select depart_date, sum(nominal_activity) as nominal_activity, sum(nominal_hotel) as nominal_hotel, 
sum(nominal_activity + nominal_hotel) as 'HotelAc' from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now())");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    $xnominal_activity = $xnominal_activity + $row['nominal_activity'];
    $xnominal_hotel = $xnominal_hotel + $row['nominal_hotel'];
    $HotelAc = $HotelAc + $row['HotelAc'];
}

$TotalBoat =0;
$stmt = $pdo->prepare("select sum(nominal_boat) as 'jum' from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now()) ");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    $TotalBoat =  $row['jum'];
}

$TotalExtra =0;
$stmt = $pdo->prepare("select sum(nominal_extra_charge) as 'jum' from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now()) ");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    $TotalExtra =  $row['jum'];
}

$TotalAdditional =0;
$stmt = $pdo->prepare("select sum(nominal_additional) as 'jum' from sysoffice_pendapatan where month(depart_date) = month(now()) and year(depart_date) = year(now()) ");
$stmt ->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
{
    $TotalAdditional =  $row['jum'];
}

$today = date("Y-m-d");

$query = "select aa.*, 
            bb.depart_time as 'depart_time0930', bb.nominal_total_price as 'nominal_total_price0930', bb.wna_adult as 'wna_adult0930', bb.wna_child as 'wna_child0930', bb.wni_adult as 'wni_adult0930', bb.wni_child as 'wni_child0930', bb.foc as 'foc0930', bb.guide as 'guide0930', bb.infant as 'infant0930', bb.cargo as 'cargo0930', bb.total as 'total0930',
            cc.depart_time as 'depart_time1230', cc.nominal_total_price as 'nominal_total_price1230', cc.wna_adult as 'wna_adult1230', cc.wna_child as 'wna_child1230', cc.wni_adult as 'wni_adult1230', cc.wni_child as 'wni_child1230', cc.foc as 'foc1230', cc.guide as 'guide1230', cc.infant as 'infant1230', cc.cargo as 'cargo1230', cc.total as 'total1230',
            dd.depart_time as 'depart_time1400', dd.nominal_total_price as 'nominal_total_price1400', dd.wna_adult as 'wna_adult1400', dd.wna_child as 'wna_child1400', dd.wni_adult as 'wni_adult1400', dd.wni_child as 'wni_child1400', dd.foc as 'foc1400', dd.guide as 'guide1400', dd.infant as 'infant1400', dd.cargo as 'cargo1400', dd.total as 'total1400',
            ee.depart_time as 'depart_time1600', ee.nominal_total_price as 'nominal_total_price1600', ee.wna_adult as 'wna_adult1600', ee.wna_child as 'wna_child1600', ee.wni_adult as 'wni_adult1600', ee.wni_child as 'wni_child1600', ee.foc as 'foc1600', ee.guide as 'guide1600', ee.infant as 'infant1600', ee.cargo as 'cargo1600', ee.total as 'total1600',
            ff.depart_time as 'depart_time1700', ff.nominal_total_price as 'nominal_total_price1700', ff.wna_adult as 'wna_adult1700', ff.wna_child as 'wna_child1700', ff.wni_adult as 'wni_adult1700', ff.wni_child as 'wni_child1700', ff.foc as 'foc1700', ff.guide as 'guide1700', ff.infant as 'infant1700', ff.cargo as 'cargo1700', ff.total as 'total1700'
            from view_net0830 aa, view_net0930 bb, view_net1230 cc, view_net1400 dd, view_net1600 ee, view_net1700 ff
            where 
            aa.depart_date = bb.depart_date and 
            aa.depart_date = cc.depart_date and 
            aa.depart_date = dd.depart_date and
            aa.depart_date = ee.depart_date and
            aa.depart_date = ff.depart_date";
$stmt = $pdo->prepare($query);
$stmt->execute();
$data_laporan = $stmt->fetchAll(PDO::FETCH_ASSOC);
$totalRow = count($data_laporan);

if(empty($data_laporan)){
  make_empty_spreadsheet("There is nothing to report today", $today);
  send_daily_report($today);
}else {
  make_spreadsheet("Laporan Net", $data_laporan, $today, $totalRow, $Cargonya, $xnominal_hotel, $xnominal_activity, $HotelAc, $TotalBoat, $TotalExtra, $TotalAdditional);
  send_daily_report($today);
}

// Create new Spreadsheet object

function make_spreadsheet($headerText, $data, $date, $totalRow, $xCargo, $xHotel, $xActivity, $xHC, $TotalBoat, $TotalExtra, $TotalAdditional){
  $TotalPenumpangLembongan=0;
  $TotalPenumpangSanur=0;
  
  $TL_WNA_ADULT = 0;
  $TL_WNA_CHILD = 0;
  $TL_WNI_ADULT = 0;
  $TL_WNI_CHILD = 0;
  $TL_FOC = 0;
  $TL_GUIDE = 0;
  $TL_INFANT = 0;
  
  $TS_WNA_ADULT = 0;
  $TS_WNA_CHILD = 0;
  $TS_WNI_ADULT = 0;
  $TS_WNI_CHILD = 0;
  $TS_FOC = 0;
  $TS_GUIDE = 0;
  $TS_INFANT = 0;
  
    $host="202.58.195.75";
	$user_name="dcamelsy_user";
	$password="Kita@2019";
	$database_name="dcamelsy_database";

	$konek = mysqli_connect($host, $user_name, $password, $database_name);
	
	
    $TotalCargo = 0;
    $TotalAcc = 0;
    $TotalHotel = 0;
    
  $spreadsheet = new Spreadsheet();
  $activeSheet = $spreadsheet->getActiveSheet();
  $activeSheet->setTitle('Laporan Net');
  $activeSheet->getParent()->getDefaultStyle()->getFont()->setName('Noto Sans');
  $activeSheet->getDefaultRowDimension()->setRowHeight(35);
  $lastRow = $totalRow+4;

  
  $boldFont = array(
      'font' => [
        'bold' => true,
      ],

      'alignment' => [
          'horizontal' => Alignment::HORIZONTAL_CENTER,
          'vertical' => Alignment::VERTICAL_CENTER
      ],

      'borders' => [
        'vertical' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
        ],
        'top' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
        ]
      ]
  );

  $defCellStyle = array(
    'alignment' => [
      'horizontal' => Alignment::HORIZONTAL_CENTER,
      'vertical' => Alignment::VERTICAL_TOP
    ],

    'borders' => [
      'vertical' => [
          'borderStyle' => Border::BORDER_THIN,
          'color' => ['argb' => '00000000'],
      ],
    ]
  );


  $newRowStyleLembongan = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => '89c765'
        ]
    ]
);

$newRowStyleSanur = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => 'd49606'
        ]
    ]
);
    
  $activeSheet->setCellValue('A1', $headerText);
  $activeSheet->getStyle("A1")->getFont()->setSize(16);

  // Auto Width Default
  foreach (range('A','Z') as $cell) {
    $activeSheet->getColumnDimension($cell)->setAutoSize(true);
  }

  foreach (range('A','Z') as $cell) {
    $activeSheet->getColumnDimension('A'.$cell)->setAutoSize(true);
  }
  
  foreach (range('A','Z') as $cell) {
    $activeSheet->getColumnDimension('B'.$cell)->setAutoSize(true);
  }
  
  //custom last header style (border workaround)
  $activeSheet->getStyle('BU4')
  ->getBorders()->getRight()
  ->setBorderStyle(Border::BORDER_THIN);
  $activeSheet->getStyle('BU4')
  ->getBorders()->getRight()
  ->setBorderStyle(Border::BORDER_THIN);

  //Set custom header name
 $activeSheet->setCellValue('A4','No.');
  
  $activeSheet->setCellValue('B4','Tanggal');
  $activeSheet->setCellValue('C4','Time');
  $activeSheet->setCellValue('D4','WNA Adult');
  $activeSheet->setCellValue('E4','WNA Child');
  $activeSheet->setCellValue('F4','WNI Adult');
  $activeSheet->setCellValue('G4','WNI Child');
  $activeSheet->setCellValue('H4','FOC');
  $activeSheet->setCellValue('I4','Guide');
  $activeSheet->setCellValue('J4','Infant');
  $activeSheet->setCellValue('K4','Cargo');
  $activeSheet->setCellValue('L4','Total Penumpang');
  $activeSheet->setCellValue('M4','Net Price');
  
  $activeSheet->setCellValue('N4','Time');
  $activeSheet->setCellValue('O4','WNA Adult');
  $activeSheet->setCellValue('P4','WNA Child');
  $activeSheet->setCellValue('Q4','WNI Adult');
  $activeSheet->setCellValue('R4','WNI Child');
  $activeSheet->setCellValue('S4','FOC');
  $activeSheet->setCellValue('T4','Guide');
  $activeSheet->setCellValue('U4','Infant');
  $activeSheet->setCellValue('V4','Cargo');
  $activeSheet->setCellValue('W4','Total Penumpang');
  $activeSheet->setCellValue('X4','Net Price');
  
  $activeSheet->setCellValue('Y4','Time');
  $activeSheet->setCellValue('Z4','WNA Adult');
  $activeSheet->setCellValue('AA4','WNA Child');
  $activeSheet->setCellValue('AB4','WNI Adult');
  $activeSheet->setCellValue('AC4','WNI Child');
  $activeSheet->setCellValue('AD4','FOC');
  $activeSheet->setCellValue('AE4','Guide');
  $activeSheet->setCellValue('AF4','Infant');
  $activeSheet->setCellValue('AG4','Cargo');
  $activeSheet->setCellValue('AH4','Total Penumpang');
  $activeSheet->setCellValue('AI4','Net Price');
  
  $activeSheet->setCellValue('AJ4','Time');
  $activeSheet->setCellValue('AK4','WNA Adult');
  $activeSheet->setCellValue('AL4','WNA Child');
  $activeSheet->setCellValue('AM4','WNI Adult');
  $activeSheet->setCellValue('AN4','WNI Child');
  $activeSheet->setCellValue('AO4','FOC');
  $activeSheet->setCellValue('AP4','Guide');
  $activeSheet->setCellValue('AQ4','Infant');
  $activeSheet->setCellValue('AR4','Cargo');
  $activeSheet->setCellValue('AS4','Total Penumpang');
  $activeSheet->setCellValue('AT4','Net Price');
  
  $activeSheet->setCellValue('AU4','Time');
  $activeSheet->setCellValue('AV4','WNA Adult');
  $activeSheet->setCellValue('AW4','WNA Child');
  $activeSheet->setCellValue('AX4','WNI Adult');
  $activeSheet->setCellValue('AY4','WNI Child');
  $activeSheet->setCellValue('AZ4','FOC');
  $activeSheet->setCellValue('BA4','Guide');
  $activeSheet->setCellValue('BB4','Infant');
  $activeSheet->setCellValue('BC4','Cargo');
  $activeSheet->setCellValue('BD4','Total Penumpang');
  $activeSheet->setCellValue('BE4','Net Price');
  
  $activeSheet->setCellValue('BF4','Time');
  $activeSheet->setCellValue('BG4','WNA Adult');
  $activeSheet->setCellValue('BH4','WNA Child');
  $activeSheet->setCellValue('BI4','WNI Adult');
  $activeSheet->setCellValue('BJ4','WNI Child');
  $activeSheet->setCellValue('BK4','FOC');
  $activeSheet->setCellValue('BL4','Guide');
  $activeSheet->setCellValue('BM4','Infant');
  $activeSheet->setCellValue('BN4','Cargo');
  $activeSheet->setCellValue('BO4','Total Penumpang');
  $activeSheet->setCellValue('BP4','Net Price');
  
  $activeSheet->setCellValue('BQ4','Total Net Price');
  $activeSheet->setCellValue('BR4','Grand Total Penumpang');
  
  $activeSheet->setCellValue('BS4','Nominal Cargo (Rp.)');
  $activeSheet->setCellValue('BT4','Nominal Hotel (Rp.)');
  $activeSheet->setCellValue('BU4','Nominal Activity (Rp.)');

  //Set Font Style
  $activeSheet->getStyle('A4:BU4')->applyFromArray($boldFont);

  $activeSheet->getStyle('A4:M4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('89c765');
  
  
  $activeSheet->getStyle('N4:X4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('d49606');
  
  
   $activeSheet->getStyle('Y4:AI4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('89c765');
  
  $activeSheet->getStyle('AJ4:AT4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('d49606');
  
  
   $activeSheet->getStyle('AU4:BE4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('89c765');
  
  $activeSheet->getStyle('BF4:BP4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('d49606');
  
  
  $activeSheet->getStyle('BQ4:BU4')->getFill()
  ->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('8c0488');
  
  
  
  //Set Default Cell Style
  $activeSheet->getStyle('A5:BU'.$lastRow)->applyFromArray($defCellStyle);

  
  foreach($data as $key => $domain) {
      
    $tanggalSub = $domain['depart_date'];
    
    $ssqlSub = "SELECT sum(nominal_cargo) as jum FROM sysoffice_pendapatan WHERE depart_date='$tanggalSub' and nominal_cargo <>'0'";
    if ($resultSub=mysqli_query($konek,$ssqlSub))
        {
            while ($rowSub=mysqli_fetch_row($resultSub))
            {
                $TotalCargo= $rowSub[0];
            }
    }
    
    $ssqlHotel = "SELECT sum(nominal_hotel) as jum FROM sysoffice_pendapatan WHERE depart_date='$tanggalSub' and nominal_hotel <>'0'";
    if ($resultHotel=mysqli_query($konek,$ssqlHotel))
        {
            while ($rowHotel=mysqli_fetch_row($resultHotel))
            {
                $TotalHotel = $rowHotel[0];
            }
    }
    
    
    $ssqlAcc = "SELECT sum(nominal_activity) as jum FROM sysoffice_pendapatan WHERE depart_date='$tanggalSub' and nominal_activity <>'0'";
    if ($resultAcc=mysqli_query($konek,$ssqlAcc))
        {
            while ($rowAcc=mysqli_fetch_row($resultAcc))
            {
                $TotalAcc = $rowAcc[0];
            }
    }
    

    
    $row = (int)$key+5;
    $activeSheet->setCellValue('A'.$row, $key+1);
    
    $activeSheet->setCellValue('B'.$row, $domain['depart_date']);
    $activeSheet->setCellValue('C'.$row, $domain['depart_time']);
    $activeSheet->getStyle('C'.$row)->applyFromArray($newRowStyleLembongan);
    $activeSheet->setCellValue('D'.$row, $domain['wna_adult']); 
    $activeSheet->setCellValue('E'.$row, $domain['wna_child']); 
    $activeSheet->setCellValue('F'.$row, $domain['wni_adult']); 
    $activeSheet->setCellValue('G'.$row, $domain['wni_child']);
    $activeSheet->setCellValue('H'.$row, $domain['foc']); 
    $activeSheet->setCellValue('I'.$row, $domain['guide']);
    $activeSheet->setCellValue('J'.$row, $domain['infant']);
    $activeSheet->setCellValue('K'.$row, $domain['cargo']);
    $activeSheet->setCellValue('L'.$row, $domain['total']); 
    $activeSheet->setCellValue('M'.$row, $domain['nominal_total_price']);
    
    $activeSheet->setCellValue('N'.$row, $domain['depart_time0930']);
    $activeSheet->getStyle('N'.$row)->applyFromArray($newRowStyleSanur);
    $activeSheet->setCellValue('O'.$row, $domain['wna_adult0930']); 
    $activeSheet->setCellValue('P'.$row, $domain['wna_child0930']); 
    $activeSheet->setCellValue('Q'.$row, $domain['wni_adult0930']); 
    $activeSheet->setCellValue('R'.$row, $domain['wni_child0930']);
    $activeSheet->setCellValue('S'.$row, $domain['foc0930']); 
    $activeSheet->setCellValue('T'.$row, $domain['guide0930']);
    $activeSheet->setCellValue('U'.$row, $domain['infant0930']);
    $activeSheet->setCellValue('V'.$row, $domain['cargo0930']);
    $activeSheet->setCellValue('W'.$row, $domain['total0930']); 
    $activeSheet->setCellValue('X'.$row, $domain['nominal_total_price0930']);
    
    $activeSheet->setCellValue('Y'.$row, $domain['depart_time1230']);
    $activeSheet->getStyle('Y'.$row)->applyFromArray($newRowStyleLembongan);
    $activeSheet->setCellValue('Z'.$row, $domain['wna_adult1230']); 
    $activeSheet->setCellValue('AA'.$row, $domain['wna_child1230']); 
    $activeSheet->setCellValue('AB'.$row, $domain['wni_adult1230']); 
    $activeSheet->setCellValue('AC'.$row, $domain['wni_child1230']);
    $activeSheet->setCellValue('AD'.$row, $domain['foc1230']); 
    $activeSheet->setCellValue('AE'.$row, $domain['guide1230']);
    $activeSheet->setCellValue('AF'.$row, $domain['infant1230']);
    $activeSheet->setCellValue('AG'.$row, $domain['cargo1230']);
    $activeSheet->setCellValue('AH'.$row, $domain['total1230']); 
    $activeSheet->setCellValue('AI'.$row, $domain['nominal_total_price1230']);
    
    $activeSheet->setCellValue('AJ'.$row, $domain['depart_time1400']);
    $activeSheet->getStyle('AJ'.$row)->applyFromArray($newRowStyleSanur);
    $activeSheet->setCellValue('AK'.$row, $domain['wna_adult1400']); 
    $activeSheet->setCellValue('AL'.$row, $domain['wna_child1400']); 
    $activeSheet->setCellValue('AM'.$row, $domain['wni_adult1400']); 
    $activeSheet->setCellValue('AN'.$row, $domain['wni_child1400']);
    $activeSheet->setCellValue('AO'.$row, $domain['foc1400']); 
    $activeSheet->setCellValue('AP'.$row, $domain['guide1400']);
    $activeSheet->setCellValue('AQ'.$row, $domain['infant1400']);
    $activeSheet->setCellValue('AR'.$row, $domain['cargo1400']);
    $activeSheet->setCellValue('AS'.$row, $domain['total1400']); 
    $activeSheet->setCellValue('AT'.$row, $domain['nominal_total_price1400']);
    
    $activeSheet->setCellValue('AU'.$row, $domain['depart_time1600']);
    $activeSheet->getStyle('AU'.$row)->applyFromArray($newRowStyleLembongan);
    $activeSheet->setCellValue('AV'.$row, $domain['wna_adult1600']); 
    $activeSheet->setCellValue('AW'.$row, $domain['wna_child1600']); 
    $activeSheet->setCellValue('AX'.$row, $domain['wni_adult1600']); 
    $activeSheet->setCellValue('AY'.$row, $domain['wni_child1600']);
    $activeSheet->setCellValue('AZ'.$row, $domain['foc1600']); 
    $activeSheet->setCellValue('BA'.$row, $domain['guide1600']);
    $activeSheet->setCellValue('BB'.$row, $domain['infant1600']);
    $activeSheet->setCellValue('BC'.$row, $domain['cargo1600']);
    $activeSheet->setCellValue('BD'.$row, $domain['total1600']); 
    $activeSheet->setCellValue('BE'.$row, $domain['nominal_total_price1600']);
    
    $activeSheet->setCellValue('BF'.$row, $domain['depart_time1700']);
    $activeSheet->getStyle('BF'.$row)->applyFromArray($newRowStyleSanur);
    $activeSheet->setCellValue('BG'.$row, $domain['wna_adult1700']); 
    $activeSheet->setCellValue('BH'.$row, $domain['wna_child1700']); 
    $activeSheet->setCellValue('BI'.$row, $domain['wni_adult1700']); 
    $activeSheet->setCellValue('BJ'.$row, $domain['wni_child1700']);
    $activeSheet->setCellValue('BK'.$row, $domain['foc1700']); 
    $activeSheet->setCellValue('BL'.$row, $domain['guide1700']);
    $activeSheet->setCellValue('BM'.$row, $domain['infant1700']);
    $activeSheet->setCellValue('BN'.$row, $domain['cargo1700']);
    $activeSheet->setCellValue('BO'.$row, $domain['total1700']); 
    $activeSheet->setCellValue('BP'.$row, $domain['nominal_total_price1700']);
    
    $activeSheet->setCellValue('BQ'.$row, $domain['nominal_total_price'] + $domain['nominal_total_price0930'] + $domain['nominal_total_price1230'] + $domain['nominal_total_price1400'] + $domain['nominal_total_price1600'] + $domain['nominal_total_price1700']); 
    $activeSheet->setCellValue('BR'.$row, $domain['total'] + $domain['total0930'] + $domain['total1230'] + $domain['total1400'] + $domain['total1600'] + $domain['total1700']); 
    
    $activeSheet->setCellValue('BS'.$row, $TotalCargo); 
    $activeSheet->setCellValue('BT'.$row, $TotalHotel); 
    $activeSheet->setCellValue('BU'.$row, $TotalAcc); 
    
    
    $TL_WNA_ADULT = $TL_WNA_ADULT + ($domain['wna_adult'] + $domain['wna_adult1230'] + $domain['wna_adult1600']);
    $TL_WNA_CHILD = $TL_WNA_CHILD + ($domain['wna_child'] + $domain['wna_child1230'] + $domain['wna_child1600']);
    $TL_WNI_ADULT = $TL_WNI_ADULT + ($domain['wni_adult'] + $domain['wni_adult1230'] + $domain['wni_adult1600']);
    $TL_WNI_CHILD = $TL_WNI_CHILD + ($domain['wni_child'] + $domain['wni_child1230'] + $domain['wni_child1600']);
    $TL_FOC = $TL_FOC + ($domain['foc'] + $domain['foc1230'] + $domain['foc1600']);
    $TL_GUIDE = $TL_GUIDE + ($domain['guide'] + $domain['guide1230'] + $domain['guide1600']);
    $TL_INFANT = $TL_INFANT + ($domain['infant'] + $domain['infant1230'] + $domain['infant1600']);
    
    $TotalPenumpangLembongan =  $TL_WNA_ADULT + $TL_WNA_CHILD + $TL_WNI_ADULT + $TL_WNI_CHILD + $TL_FOC + $TL_GUIDE;
    
    
    
    $TS_WNA_ADULT = $TS_WNA_ADULT + ($domain['wna_adult0930'] + $domain['wna_adult1400'] + $domain['wna_adult1700']);
    $TS_WNA_CHILD = $TS_WNA_CHILD + ($domain['wna_child0930'] + $domain['wna_child1400'] + $domain['wna_child1700']);
    $TS_WNI_ADULT = $TS_WNI_ADULT + ($domain['wni_adult0930'] + $domain['wni_adult1400'] + $domain['wni_adult1700']);
    $TS_WNI_CHILD = $TS_WNI_CHILD + ($domain['wni_child0930'] + $domain['wni_child1400'] + $domain['wni_child1700']);
    $TS_FOC = $TS_FOC + ($domain['foc0930'] + $domain['foc1400'] + $domain['foc1700']);
    $TS_GUIDE = $TS_GUIDE + ($domain['guide0930'] + $domain['guide1400'] + $domain['guide1700']);
    $TS_INFANT = $TS_INFANT + ($domain['infant0930'] + $domain['infant1400'] + $domain['infant1700']);
    
    $TotalPenumpangSanur =  $TS_WNA_ADULT + $TS_WNA_CHILD + $TS_WNI_ADULT + $TS_WNI_CHILD + $TS_FOC + $TS_GUIDE;
    
  }

  $newRowStyle = array(
    'font' => [
      'bold' => true,
    ],

    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ],

    'borders' => [
      'allBorders' => [
        'borderStyle' => Border::BORDER_THIN,
        'color' => ['argb' => '00000000']
      ]
    ],

    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => [
            'rgb' => 'f79448'
        ]
    ]
);

  $newRow = $lastRow+1;
  $activeSheet->setCellValue('A'.$newRow, 'TOTAL');
  $activeSheet->mergeCells('A'.$newRow. ':C'.$newRow);
  $activeSheet->getStyle('A'.$newRow)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$newRow)->applyFromArray($newRowStyle);

  //insert sum on cells H9:AD9, eg H9=sum(H5:H8)
  foreach (range('C','Z') as $cell) {
    $activeSheet->setCellValue($cell.$newRow, '=SUM('.$cell.'5:' .$cell.$lastRow .')');
    $activeSheet->getStyle($cell.$newRow)->applyFromArray($newRowStyle);
  }
  
  foreach (range('A','Z') as $cell) {
    $activeSheet->setCellValue('A'.$cell.$newRow, '=SUM(A'.$cell.'5:A' .$cell.$lastRow .')');
    $activeSheet->getStyle('A'.$cell.$newRow)->applyFromArray($newRowStyle);
  }
  
  foreach (range('A','U') as $cell) {
    $activeSheet->setCellValue('B'.$cell.$newRow, '=SUM(B'.$cell.'5:B' .$cell.$lastRow .')');
    $activeSheet->getStyle('B'.$cell.$newRow)->applyFromArray($newRowStyle);
  }
  
  //set number format
  $activeSheet->getStyle('D5:BU'.$newRow)->getNumberFormat()
  ->setFormatCode('#,##0');
  
  //Resume HEADER -----------------------------------------------
  $barisBaru = $lastRow + 4;
  $activeSheet->setCellValue('B'.$barisBaru, 'WNA ADULT');
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('C'.$barisBaru, 'WNA CHILD');
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('D'.$barisBaru, 'WNI ADULT');
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('E'.$barisBaru, 'WNI CHILD');
  $activeSheet->getStyle('E'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('E'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('F'.$barisBaru, 'FOC');
  $activeSheet->getStyle('F'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('F'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('G'.$barisBaru, 'GUIDE');
  $activeSheet->getStyle('G'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('G'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('H'.$barisBaru, 'INFANT');
  $activeSheet->getStyle('H'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('H'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('I'.$barisBaru, 'GRAND TOTAL');
  $activeSheet->getStyle('I'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('I'.$barisBaru)->applyFromArray($newRowStyle);
  
  
  //Iisi
  $barisBaru = $lastRow + 5;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL PASSENGER LEMBONGAN');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $TL_WNA_ADULT);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('C'.$barisBaru, $TL_WNA_CHILD);
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('C'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('D'.$barisBaru, $TL_WNI_ADULT);
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('D'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('E'.$barisBaru, $TL_WNI_CHILD);
  $activeSheet->getStyle('E'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('E'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('E'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('F'.$barisBaru, $TL_FOC);
  $activeSheet->getStyle('F'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('F'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('F'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('G'.$barisBaru, $TL_GUIDE);
  $activeSheet->getStyle('G'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('G'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('G'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('H'.$barisBaru, $TL_INFANT);
  $activeSheet->getStyle('H'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('H'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('H'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('I'.$barisBaru, $TotalPenumpangLembongan);
  $activeSheet->getStyle('I'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('I'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('I'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  
  
  $barisBaru = $lastRow + 6;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL PASSENGER SANUR');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $TS_WNA_ADULT);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('C'.$barisBaru, $TS_WNA_CHILD);
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('C'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('D'.$barisBaru, $TS_WNI_ADULT);
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('D'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('E'.$barisBaru, $TS_WNI_CHILD);
  $activeSheet->getStyle('E'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('E'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('E'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('F'.$barisBaru, $TS_FOC);
  $activeSheet->getStyle('F'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('F'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('F'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('G'.$barisBaru, $TS_GUIDE);
  $activeSheet->getStyle('G'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('G'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('G'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('H'.$barisBaru, $TS_INFANT);
  $activeSheet->getStyle('H'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('H'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('H'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('I'.$barisBaru, $TotalPenumpangSanur);
  $activeSheet->getStyle('I'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('I'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('I'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  
  $barisBaru = $lastRow + 7;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL LEMBONGAN + SANUR');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $TS_WNA_ADULT + $TL_WNA_ADULT);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('C'.$barisBaru, $TS_WNA_CHILD + $TL_WNA_CHILD);
  $activeSheet->getStyle('C'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('C'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('C'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('D'.$barisBaru, $TS_WNI_ADULT + $TL_WNI_ADULT);
  $activeSheet->getStyle('D'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('D'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('D'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('E'.$barisBaru, $TS_WNI_CHILD + $TL_WNI_CHILD);
  $activeSheet->getStyle('E'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('E'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('E'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('F'.$barisBaru, $TS_FOC + $TL_FOC);
  $activeSheet->getStyle('F'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('F'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('F'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('G'.$barisBaru, $TS_GUIDE + $TL_GUIDE);
  $activeSheet->getStyle('G'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('G'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('G'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('H'.$barisBaru, $TS_INFANT + $TL_INFANT);
  $activeSheet->getStyle('H'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('H'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('H'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  $activeSheet->setCellValue('I'.$barisBaru, $TotalPenumpangSanur + $TotalPenumpangLembongan);
  $activeSheet->getStyle('I'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('I'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('I'.$barisBaru)->getNumberFormat()->setFormatCode('#,##');
  
  
  //Totalan yg baru
   $barisBaru = $lastRow+9;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL CARGO');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $xCargo);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $barisBaru = $lastRow+10;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL ACTIVITY');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $xActivity);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $barisBaru = $lastRow+11;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL HOTEL');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $xHotel);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  $barisBaru = $lastRow+12;
  $activeSheet->setCellValue('A'.$barisBaru, 'HOTEL +  ACTIVITY');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $xHC);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  
  //Bawahnya , $TotalBoat, $TotalExtra
  $barisBaru = $lastRow+13;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL BOAT');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $TotalBoat);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  
  $barisBaru = $lastRow+14;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL EXTRA');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $TotalExtra);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  
  //Total Additinonal
  $barisBaru = $lastRow+15;
  $activeSheet->setCellValue('A'.$barisBaru, 'TOTAL ADDITIONAL');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $TotalAdditional);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  
  $barisBaru = $lastRow+16;
  $activeSheet->setCellValue('A'.$barisBaru, 'GRAND TOTAL');
  $activeSheet->getStyle('A'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('A'.$barisBaru)->applyFromArray($newRowStyle);
  
  $activeSheet->setCellValue('B'.$barisBaru, $xCargo + $xActivity +  $xHotel + $TotalBoat + $TotalExtra  + $TotalAdditional);
  $activeSheet->getStyle('B'.$barisBaru)->getFont()->setSize(14);
  $activeSheet->getStyle('B'.$barisBaru)->applyFromArray($newRowStyle);
  $activeSheet->getStyle('B'.$barisBaru)->getNumberFormat()->setFormatCode('#,##0.00');
  
  
  // Redirect output to a client's web browser (Xlsx)
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment;filename="webstats.xlsx"');
  header('Cache-Control: max-age=0');
  
  $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
  $writer->save('laporan-net_'. $date .'.xlsx');
  //exit;
}

function make_empty_spreadsheet($headerText, $date){
  $spreadsheet = new Spreadsheet();
  $activeSheet = $spreadsheet->getActiveSheet();
  $activeSheet->setTitle('Laporan Net');
  $activeSheet->getParent()->getDefaultStyle()->getFont()->setName('Times New Roman');
  $activeSheet->setCellValue('A1', $headerText);
  $activeSheet->getStyle("A1")->getFont()->setSize(16);

  $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
  $writer->save('laporan-net_'. $date .'.xlsx');
  //exit;
}

function send_daily_report($date){
  $file = "laporan-net_". $date .".xlsx";
  $mimetype = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
  $encoding = 'base64';
  
  $mail = new PHPMailer();
  $mail->IsSMTP();
  $mail->SMTPDebug = 1; 
  $mail->SMTPAuth = true; 
  $mail->SMTPSecure = 'ssl'; 
  $mail->Host = "mail.dcamelfastferry.com";
  $mail->Port = 465;
  $mail->IsHTML(true);
  $mail->Username = "system@dcamelfastferry.com";
  $mail->Password = "Kita@2019";
  $mail->SetFrom("system@dcamelfastferry.com");
  $mail->Subject = "Laporan Net ".$date;
  $mail->Body = $IsiEmail;
  
  //$mail->AddAddress("laporandcamel@gmail.com");
  //$mail->AddCC("accounting@dcamelfastferry.com");
  $mail->AddAddress("muriarka.gede@gmail.com");
  
  $mail->addAttachment($file, $file, $encoding, $mimetype);

  if(!$mail->Send()) {
      echo "Mailer Error: " . $mail->ErrorInfo;
  } else {
      echo "Message has been sent";
  }
}

?>
